/* globals zlFetch */
// ========================
// Variables
// ========================
const typeahead = document.querySelector('.typeahead')

// ========================
// Functions
// ========================
const boldSearchTerms = (string, searchTerms) => {
  const length = searchTerms.length
  const toBold = string.substring(0, length)
  const restOfString = string.substring(length)
  return `<strong>${toBold}</strong>${restOfString}`
}

const initTypeahead = (typeahead, countries) => {
  const input = typeahead.querySelector('input')
  const ul = typeahead.querySelector('ul')

  // Shows predictions
  input.addEventListener('input', event => {
    const input = event.target
    const inputValue = input.value.trim().toLowerCase()

    // Hides list if user typed nothing
    // (or empties input field)
    if (!inputValue) return ul.setAttribute('hidden', true)

    // Finds a list of matched countries
    const matches = countries.filter(country => {
      const name = country.name.toLowerCase()
      return name.startsWith(inputValue)
    })

    // Creates the innerHTML
    const listItems = matches.map(country => {
      return `<li>
        <img src="${country.flag}" alt="${country.name}'s flag" />
        <span>${boldSearchTerms(country.name, inputValue)}</span>
      </li>`
    })
      .join('')

    // Shows list
    ul.innerHTML = listItems
    ul.removeAttribute('hidden')
  })

  // Lets users select a prediction
  ul.addEventListener('click', event => {
    const prediction = event.target.closest('li')
    if (!prediction) return

    const span = prediction.querySelector('span')
    const countryName = span.textContent
    input.value = countryName
    ul.setAttribute('hidden', true)
  })

  document.addEventListener('click', event => {
    if (!event.target.closest('.typeahead')) {
      ul.setAttribute('hidden', true)
    }
  })
}

// ========================
// Execution
// ========================
zlFetch('https://restcountries.eu/rest/v2/all?fields=name;flag')
  .then(response => initTypeahead(typeahead, response.body))
  .catch(error => console.log(error))
