/* eslint-env browser */
const initial = {
  components: {},
  props: {}
}

export default function Tiny (options) {
  options = Object.assign({}, initial, options)

  const element = typeof options.selector === 'string'
    ? document.querySelector(options.selector)
    : options.selector

  options.element = element

  options.setState = function (newState) {
    const entries = Object.entries(newState)
    for (const entry of entries) {
      options.state[entry[0]] = entry[1]
    }

    _render(options)
    _addEventListeners(options)
    _renderChildComponents(options)
  }

  options.emit = function (eventName, detail, eventOpts = {}) {
    const event = new CustomEvent(eventName, {
      bubbles: true,
      detail,
      ...eventOpts
    })
    options.element.dispatchEvent(event)
  }

  function _render (options) {
    options.element.innerHTML = options.template()
  }

  function _addEventListeners (options) {
    const listenerElements = options.element.querySelectorAll('[tiny-listener]')
    for (const listenerElement of listenerElements) {
      const attribute = listenerElement.getAttribute('tiny-listener')

      const listenerInfo = attribute
        .replace('[', '')
        .replace(']', '')
        .split(',')
        .map(l => l.trim())

      const [eventName, fn] = listenerInfo

      listenerElement.addEventListener(eventName, options[fn].bind(options))
    }
  }

  function _renderChildComponents (options) {
    const compEls = options.element.querySelectorAll('[tiny-component]')

    for (const compEl of compEls) {
      const compName = compEl.getAttribute('tiny-component')
      const comp = options.components[compName]

      comp.element = compEl

      _addProps(comp)
      _render(comp)
      _addEventListeners(comp)
    }
  }

  function _addProps (comp) {
    const attribute = comp.element.getAttribute('tiny-props')
    if (!attribute) return

    const props = attribute
      .replace('[', '')
      .replace(']', '')
      .split(',')
      .map(l => l.trim())

    const prop = props[0]
    let value = props[1]

    if (value.includes('.')) {
      value = value
        .split('.')
        .reduce((acc, current) => acc[current], options)
      comp.props[prop] = value
      return
    }

    if (options[value]) {
      comp.props[prop] = options[value]
      return
    }

    comp.props[prop] = value
  }

  if (options.selector) {
    _render(options)
    _addEventListeners(options)
    _renderChildComponents(options)
  }

  return options
}
