/* eslint-env browser */
// Start writing JavaScript here!
const callback = entries => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.classList.add('is-visible')
    }

    if (!entry.isIntersecting && entry.boundingClientRect.top > 0) {
      entry.target.classList.remove('is-visible')
    }
  })
}
const observer = new IntersectionObserver(callback)

const books = document.querySelectorAll('.book')
books.forEach(book => observer.observe(book))
