const defaults = {
  buttonElement: '',
  modalElement: '',
  afterOpen () {}
}

export default function Modal (settings) {
  settings = Object.assign({}, defaults, settings)

  const { modalElement, buttonElement } = settings
  const overlayElement = modalElement.parentElement
  const contentElement = modalElement.querySelector('.modal__content')

  function trapFocus (event) {
    const focusables = getKeyboardFocusableElements(modalElement)
    const firstFocusable = focusables[0]
    const lastFocusable = focusables[focusables.length - 1]

    // Directs to first focusable
    if (document.activeElement === lastFocusable && event.key === 'Tab' && !event.shiftKey) {
      event.preventDefault()
      firstFocusable.focus()
    }

    // Directs to last focusable
    if (document.activeElement === firstFocusable && event.key === 'Tab' && event.shiftKey) {
      event.preventDefault()
      lastFocusable.focus()
    }
  }

  const modal = {
    open () {
      overlayElement.classList.add('is-open')
      buttonElement.setAttribute('aria-expanded', true)

      // Autofocus
      const focusableEls = getKeyboardFocusableElements(contentElement)
      if (focusableEls[0]) focusableEls[0].focus()

      // Traps focus
      document.addEventListener('keydown', trapFocus)

      // Hide other elements from screen readers
      const overlaySiblingEls = [...overlayElement.parentElement.children]
        .filter(el => el !== overlayElement)
      overlaySiblingEls.forEach(element => {
        element.setAttribute('aria-hidden', true)
      })

      settings.afterOpen()
    }
  }

  buttonElement.addEventListener('click', event => {
    modal.open()
  })
}

function getKeyboardFocusableElements (element = document) {
  return [...element.querySelectorAll(
    'a, button, input, textarea, select, details, [tabindex]'
  )]
    .filter(el => !el.hasAttribute('disabled'))
    .filter(el => !el.hasAttribute('tabindex') || el.getAttribute('tabindex') >= 0)
}
