/* global TimelineMax Back */
import 'https://cdnjs.cloudflare.com/ajax/libs/gsap/1.20.3/TweenMax.min.js'
import Modal from './modal.js'

const wavingHand = document.querySelector('.wave-hand')
const wave = _ => {
  const tl = new TimelineMax({})
  // Sets transform origin
  tl.set(wavingHand, { transformOrigin: 'bottom center' })
  tl.from(wavingHand, 0.5, { scale: 0.25, opacity: 0, ease: Back.easeOut.config(1.5) })
  tl.to(wavingHand, 0.2, { rotation: 15 })
  tl.to(wavingHand, 0.2, { rotation: -15 })
  tl.to(wavingHand, 0.2, { rotation: 15 })
  tl.to(wavingHand, 0.2, { rotation: -15 })
  tl.to(wavingHand, 0.2, { rotation: 0 })
}

Modal({
  modalElement: document.querySelector('#user-triggered-modal'),
  buttonElement: document.querySelector('#user-triggered-modal-button'),
  afterOpen: wave
})

// ========================
// Old code
// ========================
// /* global TimelineMax Back */
// const main = document.querySelector('main')
// const modal = document.querySelector('.modal')
// const modalButton = document.querySelector('.jsModalButton')
// const modalCloseButton = document.querySelector('.jsModalClose')
// const modalOverlay = document.querySelector('.modal-overlay')
// const wavingHand = document.querySelector('.wave-hand')

// /**
//  * Checks if modal is open
//  */
// const isModalOpen = _ => {
//   return document.body.classList.contains('modal-is-open')
// }

// /**
//  * Closes Modal
//  */
// const closeModal = _ => {
//   document.body.classList.remove('modal-is-open')
//   document.removeEventListener('keydown', trapFocus)
//   modalButton.setAttribute('aria-expanded', false)
//   main.removeAttribute('aria-hidden')
//   modalButton.focus()
// }

// modalCloseButton.addEventListener('click', event => {
//   closeModal()
// })

// modalOverlay.addEventListener('click', event => {
//   if (!event.target.closest('.modal')) {
//     closeModal()
//   }
// })

// document.addEventListener('keydown', event => {
//   if (isModalOpen() && event.key === 'Escape') {
//     closeModal()
//   }
// })
