/* eslint-env browser */
/* globals zlFetch */
// Start writing JavaScript here!
const endpoint = 'https://api.learnjavascript.today/letters'
const lettersElement = document.querySelector('.letters')
const spinner = document.querySelector('.spinner')
const loadMoreButton = document.querySelector('.load-more-button')
const dribbbleSection = document.querySelector('.dribbble-section')

// Initial Fetch
zlFetch(`${endpoint}?limit=6&page=1`)
  .then(response => {
    const { nextPage, letters } = response.body
    const fragment = document.createDocumentFragment()

    letters.forEach(letter => {
      const li = document.createElement('li')
      li.innerHTML = `
        <a class="letter" href="${letter.shotUrl}">
          <span>By ${letter.creator}</span>
          <img src="${letter.imageUrl}" alt="Picture of ${letter.letter}" width="400" height="300">
        </a>
      `
      fragment.appendChild(li)
    })

    lettersElement.appendChild(fragment)

    spinner.setAttribute('hidden', true)
    loadMoreButton.dataset.nextPage = nextPage
  })

loadMoreButton.addEventListener('click', event => {
  spinner.removeAttribute('hidden')
  loadMoreButton.setAttribute('hidden', true)

  zlFetch(loadMoreButton.dataset.nextPage)
    .then(response => {
      const { nextPage, letters } = response.body
      const fragment = document.createDocumentFragment()
      letters.forEach(letter => {
        const li = document.createElement('li')
        li.innerHTML = `
          <a class="letter" href="${letter.shotUrl}">
            <span>By ${letter.creator}</span>
            <img src="${letter.imageUrl}" alt="Picture of ${letter.letter}" width="400" height="300">
          </a>
        `
        fragment.appendChild(li)
      })

      lettersElement.appendChild(fragment)

      spinner.setAttribute('hidden', true)
      loadMoreButton.removeAttribute('hidden')

      if (nextPage) {
        loadMoreButton.dataset.nextPage = nextPage
      } else {
        loadMoreButton.setAttribute('hidden', true)
        dribbbleSection.removeAttribute('hidden')
      }
    })
})
