/* globals google */
// ========================
// Functions
// ========================
/**
 * Fetch Google Maps API (JSONP).
 */
const fetchGoogleMapsApi = _ => {
  // Please change this to use your own API key!
  const apiKey = 'AIzaSyBOSppjMrbl5YQAUla6O9WNAL1w2zeWtLc'
  const script = document.createElement('script')
  script.src = `https://maps.googleapis.com/maps/api/js?key=${apiKey}&libraries=places&callback=initGoogleMaps`
  script.addEventListener('error', console.error)

  document.body.appendChild(script)
  document.body.removeChild(script)
}

/**
 * Get directions from Google Map's Directions service
 * @param {Object} request - Google Directions API request object
 */
const getDirections = request => {
  return new Promise((resolve, reject) => {
    const directionsService = new google.maps.DirectionsService()

    directionsService.route(request, result => {
      if (result.status === 'OK') return resolve(result)
      return reject(result)
    })
  })
}

/**
 * Initializes Google Map
 * Used in findGoogleMapsApi as a callback
 */
/* eslint-disable */
function initGoogleMaps () {
/* eslint-enable */
  const mapDiv = document.querySelector('#map')
  const searchPanel = document.querySelector('.search-panel')
  const searchBoxes = [...searchPanel.querySelectorAll('.search-box')]

  // Initializes Google Map
  const map = new google.maps.Map(mapDiv, {
    center: { lat: 1.3521, lng: 103.8198 },
    zoom: 13
  })

  // Initializes the directions renderer
  const directionsRenderer = new google.maps.DirectionsRenderer({
    map,
    panel: document.querySelector('.directions-panel')
  })

  // Initializes Autocompletes
  searchBoxes.forEach(searchBox => {
    const input = searchBox.querySelector('input')
    const autocomplete = new google.maps.places.Autocomplete(input)
    autocomplete.bindTo('bounds', map)
  })

  // Draws route between two directions
  searchPanel.addEventListener('submit', event => {
    event.preventDefault()

    // Clears errors
    const errorDiv = searchPanel.querySelector('.search-panel__error')
    errorDiv.textContent = ''

    const originInput = searchBoxes[0].querySelector('input')
    const destinationInput = searchBoxes[1].querySelector('input')

    const origin = originInput.value.trim()
    const destination = destinationInput.value.trim()

    const request = {
      origin,
      destination,
      travelMode: 'DRIVING'
    }

    // Draw directions
    getDirections(request)
      .then(results => {
        directionsRenderer.setDirections(results)
      })
      .catch(results => {
        const errors = {
          INVALID_REQUEST: 'Invalid request',
          MAX_WAYPOINTS_EXCEEDED: 'Maximum of 8 waypoints allowed',
          NOT_FOUND: 'At least one location cannot be geocoded',
          OVER_QUERY_LIMIT: 'You sent too many requests in a short time. Slow down!',
          UNKNOWN_ERROR: 'An error happened on the server. Please try again later',
          ZERO_RESULTS: 'Cannot find route between origin and destination'
        }
        const message = errors[results.status]
        const errorDiv = searchPanel.querySelector('.search-panel__error')
        errorDiv.textContent = message
      })
  })
}

fetchGoogleMapsApi()
