// Start writing JavaScript here!
const draggables = document.querySelectorAll('[data-draggable]')

draggables.forEach(draggable => {
  draggable.addEventListener('pointerdown', event => {
    const target = event.target
    const box = target.getBoundingClientRect()
    let prevScreenX = event.screenX
    let prevScreenY = event.screenY

    const clone = target.cloneNode(true)
    document.body.append(clone)
    clone.style.position = 'absolute'
    clone.style.transform = 'rotate(-5deg)'
    clone.style.left = `${box.left}px`
    clone.style.top = `${box.top}px`
    clone.style.width = `${box.width}px`
    clone.style.height = `${box.height}px`
    target.style.opacity = '0'

    clone.setPointerCapture(event.pointerId)

    clone.addEventListener('pointermove', event => {
      const movementX = event.screenX - prevScreenX
      const movementY = event.screenY - prevScreenY
      prevScreenX = event.screenX
      prevScreenY = event.screenY

      const left = parseFloat(clone.style.left)
      const top = parseFloat(clone.style.top)

      clone.style.left = `${left + movementX}px`
      clone.style.top = `${top + movementY}px`
    })

    clone.addEventListener('pointerup', event => {
      target.style.opacity = 1
      clone.style.transform = ''
      clone.releasePointerCapture(event.pointerId)
      clone.remove()

      const left = parseFloat(clone.style.left)
      const top = parseFloat(clone.style.top)
      const droppedArea = document.elementFromPoint(left, top)
      const dropzone = droppedArea.closest('[data-dropzone]')
      if (dropzone) {
        dropzone.append(target)
      }
    })
  })
})
