/* globals zlFetch */
const dotaApi = 'https://api.opendota.com/api'
const heroName = 'axe'

const heroNameEl = document.querySelector('[data-hero-name]')
const heroImageEl = document.querySelector('[data-hero-image]')
const heroDescEl = document.querySelector('[data-hero-description]')
const heroAbilitiesEl = document.querySelector('[data-hero-abilities]')

function capitalize (word) {
  return word.slice(0, 1).toUpperCase() + word.slice(1)
}

heroNameEl.textContent = capitalize(heroName)

zlFetch(`${dotaApi}/constants/heroes`)
  .then(response => {
    const heroes = Object.values(response.body).map(hero => {
      return {
        name: hero.localized_name,
        attackType: hero.attack_type.toLowerCase(),
        primaryAttribute: hero.primary_attr,
        roles: hero.roles.map(role => role.toLowerCase()),
        image: `https://api.opendota.com${hero.img}`
      }
    })
    const hero = heroes.find(h => h.name.toLowerCase() === heroName)
    heroImageEl.src = `${hero.image}`
  })
  .catch(console.log)

zlFetch(`${dotaApi}/constants/hero_lore`)
  .then(response => {
    const heroLore = response.body[heroName]
    heroDescEl.textContent = heroLore
  })

zlFetch(`${dotaApi}/constants/abilities`)
  .then(response => {
    const allAbilities = response.body

    zlFetch(`${dotaApi}/constants/hero_abilities`)
      .then(response => {
        const heroAbilities = response.body[`npc_dota_hero_${heroName}`]
          .abilities
          .filter(ability => ability !== 'generic_hidden')
          .map(ability => allAbilities[ability])
          .map(ability => {
            return {
              name: ability.dname,
              description: ability.desc,
              image: `https://api.opendota.com${ability.img}`
            }
          })
          .map(ability => {
            return `<li class="ability">
              <p class="ability__title">${ability.name}</p>
              <img class="ability__img" src="${ability.image}" alt="${ability.name}">
              <p class="desc">${ability.description}</p>
            </li>`
          })
          .join('')

        heroAbilitiesEl.innerHTML = heroAbilities
        heroAbilitiesEl.closest('section').removeAttribute('hidden')
      })
  })
