/* globals zlFetch */
const dotaApi = 'https://api.opendota.com/api'
const heroesList = document.querySelector('.heroes-list')

zlFetch(`${dotaApi}/constants/heroes`)
  .then(response => {
    const heroes = Object.values(response.body)
    heroes.forEach(hero => {
      const li = document.createElement('li')
      li.classList.add('hero')
      li.innerHTML = `
        <a href="#">
          <span class="hero__name"> ${hero.localized_name} </span>
          <img src="https://api.opendota.com${hero.img}" alt="${hero.localized_name} image">
        </a>
      `
      heroesList.appendChild(li)
    })
  })
  .catch(console.log)
