import Tiny from './Tiny/tiny.js'
import Filters from './Filters.js'

Tiny({
  selector: document.body,
  state: {
    heroes: []
  },

  components: {
    Filters
  },

  async afterMount () {
    const dotaApi = 'https://api.opendota.com/api'
    const response = await zlFetch(`${dotaApi}/constants/heroes`)
    const heroes = Object.values(response.body).map(hero => {
      return {
        name: hero.localized_name,
        npcHeroName: hero.name.replace('npc_dota_hero_', ''),
        attackType: hero.attack_type.toLowerCase(),
        primaryAttribute: hero.primary_attr,
        roles: hero.roles.map(role => role.toLowerCase()),
        image: `https://api.opendota.com${hero.img}`
      }
    })

    this.setState({ heroes })
  },

  filterHeroes (event) {
    console.log(event.detail.filteredHeroes)
  },

  template () {
    return `
      <header class="site-header">
        <div class="wrap">
          <a href="/">
            <img src="/images/logo.png" alt="Dota 2 Logo" />
          </a>
        </div>
      </header>

      <main tiny-listener="[filter-heroes, filterHeroes]">
        <div class="wrap">
          <div class="site-title">
            <h1>Heroes List</h1>
            <p>Filter heroes based on these attributes</p>
          </div>

          <div class="sidebar-content">
            <div class="sidebar flow">
              <div tiny-component="Filters" tiny-props="[heroes, state.heroes]"></div>
            </div>

            <div class="content">
              <ul class="heroes-list">
                ${this.state.heroes.map(hero => {
                  return `
                    <li>
                      <a href="#">
                        <span class="hero__name"> ${hero.name} </span>
                        <img src="${hero.image}" alt="${hero.name} image">
                      </a>
                    </li>
                  `
                }).join('')}
              </ul>
            </div>
          </div>
        </div>
      </main>
    `
  }
})
