// ========================
// Variables
// ========================
const date = new Date(2019, 1, 13)
const yearMonthIndicator = document.querySelector('.datepicker__year-month')
const dategrid = document.querySelector('.datepicker__date-grid')

const monthsInAYear = [
  'January',
  'February',
  'March',
  'April',
  'May',
  'June',
  'July',
  'August',
  'September',
  'October',
  'November',
  'December'
]

const year = date.getFullYear()
const month = date.getMonth()
const monthName = monthsInAYear[month]
const datetimeMonth = (month + 1).toString().padStart(2, '0')

const firstDayOfMonth = new Date(date.setDate(1)).getDay()
const lastDayInMonth = new Date(year, month + 1, 0)
const daysInMonth = lastDayInMonth.getDate()

// ========================
// Execution
// ========================
// Year Month Indicator
yearMonthIndicator.innerHTML = `
  <time datetime="${year}-${datetimeMonth}">${monthName} ${year}</time>
`

// Building the Date grid
for (let day = 1; day <= daysInMonth; day++) {
  const button = document.createElement('button')
  if (day === 1) button.style.setProperty('--firstDayOfMonth', firstDayOfMonth + 1)

  const datetimeDay = day.toString().padStart(2, '0')
  button.innerHTML = `
    <time datetime="${year}-${datetimeMonth}-${datetimeDay}">${day}</time>
  `

  dategrid.appendChild(button)
}
