/* globals getComputedStyle */
// This line removes the squiggly underline from `getComputedStyle`. It tells standard that `getComputedStyle` is already defined.
const carousel = document.querySelector('.carousel')
const previousButton = carousel.querySelector('.previous-button')
const nextButton = carousel.querySelector('.next-button')
const contents = carousel.querySelector('.carousel__contents')
const dotsContainer = carousel.querySelector('.carousel__dots')

const slides = [...carousel.querySelectorAll('.carousel__slide')]
const dots = [...carousel.querySelectorAll('.carousel__dot')]

// ========================
// Functions
// ========================
/**
 * Sets slide positions
 */
const setSlidePositions = _ => {
  const slideWidth = slides[0].getBoundingClientRect().width
  slides.forEach((slide, index) => {
    slide.style.left = slideWidth * index + 'px'
  })
}

/**
 * Switches slides
 * @param {HTMLElement} currentSlide
 * @param {HTMLElement} targetSlide
 */
const switchSlide = (currentSlide, targetSlide) => {
  const destination = getComputedStyle(targetSlide).left
  contents.style.transform = `translateX(-${destination})`
  currentSlide.classList.remove('is-selected')
  targetSlide.classList.add('is-selected')
}

/**
 * Highlights selected dot
 * @param {HTMLElement} currentDot
 * @param {HTMLElement} targetDot
 */
const highlightDot = (currentDot, targetDot) => {
  currentDot.classList.remove('is-selected')
  targetDot.classList.add('is-selected')
}

/**
 * Show and hide arrow buttons
 * @param {number} targetSlideIndex
 */
const showHideArrowButtons = clickedDotIndex => {
  if (clickedDotIndex === 0) {
    previousButton.setAttribute('hidden', true)
    nextButton.removeAttribute('hidden')
  } else if (clickedDotIndex === dots.length - 1) {
    previousButton.removeAttribute('hidden')
    nextButton.setAttribute('hidden', true)
  } else {
    previousButton.removeAttribute('hidden')
    nextButton.removeAttribute('hidden')
  }
}

// ========================
// Execution
// ========================
setSlidePositions()

nextButton.addEventListener('click', event => {
  const currentSlide = contents.querySelector('.is-selected')
  const nextSlide = currentSlide.nextElementSibling
  const currentDot = dotsContainer.querySelector('.is-selected')
  const nextDot = currentDot.nextElementSibling

  switchSlide(currentSlide, nextSlide)
  highlightDot(currentDot, nextDot)

  // Shows previous button
  previousButton.removeAttribute('hidden')

  // Hides next button
  if (!nextSlide.nextElementSibling) {
    nextButton.setAttribute('hidden', true)
  }
})

previousButton.addEventListener('click', event => {
  const currentSlide = contents.querySelector('.is-selected')
  const previousSlide = currentSlide.previousElementSibling
  const currentDot = dotsContainer.querySelector('.is-selected')
  const previousDot = currentDot.previousElementSibling

  switchSlide(currentSlide, previousSlide)
  highlightDot(currentDot, previousDot)

  // Shows next button
  nextButton.removeAttribute('hidden')

  // Hides previous button
  if (!previousSlide.previousElementSibling) {
    previousButton.setAttribute('hidden', true)
  }
})

dotsContainer.addEventListener('click', event => {
  const dot = event.target.closest('button')
  if (!dot) return

  // Gets variables
  const currentSlide = contents.querySelector('.is-selected')
  const currentDot = dotsContainer.querySelector('.is-selected')
  const clickedDotIndex = dots.findIndex(d => d === dot)
  const slideToShow = slides[clickedDotIndex]

  switchSlide(currentSlide, slideToShow)
  highlightDot(currentDot, dot)
  showHideArrowButtons(clickedDotIndex)
})
