import Calculator from './calculator.js'

const calculator = Calculator()
const clearButton = calculator.element.querySelector('[data-key="clear"]')

// Functions to test clear
function testClear () {
  calculator.pressKeys('5', 'clear')
  console.assert(calculator.displayValue === '0', 'Clear before calculation')
  console.assert(clearButton.textContent === 'AC', 'Clear once, should show AC')
  calculator.resetCalculator()
}

function testClearAfterCalculation () {
  calculator.pressKeys('5', 'times', '9', 'equal', 'clear')
  const { firstValue, operator } = calculator.element.dataset

  console.assert(calculator.displayValue === '0', 'Clear after calculation: Display is 0')
  console.assert(clearButton.textContent === 'AC', 'Clear after calculation: Clear Button is AC')
  console.assert(firstValue, 'Clear After Calculation: firstValue should remain')
  console.assert(operator, 'Clear After Calculation: operator should remain')

  calculator.resetCalculator()
}

function testFullClear () {
  calculator.pressKeys('5', 'times', '9', 'equal')
  calculator.resetCalculator()

  console.assert(calculator.displayValue === '0', 'Full Clear: Display is 0')
  console.assert(!calculator.element.dataset.firstValue, 'Full Clear:No first value')
  console.assert(!calculator.element.dataset.operator, 'Full Clear: No operator value')
  console.assert(!calculator.element.dataset.modifierValue, 'Full Clear: No operator value')
}

function runTest (test) {
  calculator.pressKeys(...test.keys)
  console.assert(calculator.displayValue === test.result, test.message)
  calculator.resetCalculator()
}

const tests = [
  // Test Number Keys
  {
    message: 'Number key',
    keys: ['2'],
    result: '2'
  }, {
    message: 'Number Number',
    keys: ['3', '5'],
    result: '35'
  }
]

// ========================
// Runs tests
// ========================
testClear()
testClearAfterCalculation()
testFullClear()
tests.forEach(runTest)
